/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.block;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.theawesomegem.fishingmadebetter.common.block.BlockBaitBox;
import net.theawesomegem.fishingmadebetter.common.block.tileentity.TileEntityBaitBox;

public class BlockManager {
    public static final BlockManager instance = new BlockManager();
    public static Block BLOCK_BAIT_BOX;
    public static ItemBlock ITEM_BLOCK_BAIT_BOX;

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        BLOCK_BAIT_BOX = BlockManager.registerAsBlock("baitbox", new BlockBaitBox(), registry);
        GameRegistry.registerTileEntity(TileEntityBaitBox.class, (ResourceLocation)new ResourceLocation("fishingmadebetter", "baitbox"));
    }

    public static void registerItemBlocks(IForgeRegistry<Item> registry) {
        ITEM_BLOCK_BAIT_BOX = BlockManager.registerAsItem(BLOCK_BAIT_BOX, registry);
    }

    private static Block registerAsBlock(String name, Block newBlock, IForgeRegistry<Block> registry) {
        registry.register((IForgeRegistryEntry)newBlock);
        return newBlock;
    }

    private static ItemBlock registerAsItem(Block block, IForgeRegistry<Item> registry) {
        ItemBlock newBlock = new ItemBlock(block);
        newBlock.setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)newBlock);
        return newBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        instance.registerItemBlockModels((Item)ITEM_BLOCK_BAIT_BOX);
    }

    private void registerItemBlockModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "normal"));
    }
}

